/*------------------------------------------------------------------------------------
   Name: ASCTrend-Tape.mq4
   
   Description: MTF Tape chart of the ASCTrend1 indicator.

	Note:
	   Requires that the following indicators are installed and working:
	   ASCTrend1i.mq4,
   
   Change log:
       2013-05-03. Xaphod, v1.01
         - Fixed updating of bars on all timeframes as new data is being downloaded.
         - Draw blank dot if there is not data for the bar.
       2012-??-??. Xaphod, v1.00
-------------------------------------------------------------------------------------*/
// Indicator properties
#property copyright "Copyright 2012, xaphod.com"
#property link      "http://www.xaphod.com"

#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1 RoyalBlue
#property indicator_color2 Crimson
#property indicator_color3 Silver
#property indicator_width1  4
#property indicator_width2  4
#property indicator_width3  1
#property indicator_maximum 1
#property indicator_minimum 0

//#include <xPrint.mqh>
#import "Kernel32.dll"
  int CreateFileA(string lpFileName,int dwDesiredAccess, int dwShareMode, int lpSecurityAttributes, int dwCreationDisposition,int dwFlagsAndAttributes, int hTemplateFile);
  int CloseHandle(int hObject);
#import

#define OPEN_EXISTING 3
#define FILE_SHARE_READ 1
#define GENERIC_READ 0x80000000
#define FILE_ATTRIBUTE_NORMAL 128
#define INVALID_HANDLE_VALUE 0xFFFFFFFF

// Constant definitions
#define INDICATOR_NAME "ASCTrend"
#define INDICATOR_VERSION "1.00"
#define DIVIDER_LINE 100000
#define IND_ASCTREND  "ASCTrend1i"

// indicator parameters
extern string    Indi.Version= INDICATOR_VERSION;
extern string    TimeFrame.Settings="";
extern int       TimeFrame.Period=0;       // Timeframe: 0,1,5,15,30,60,240,1440 etc. Current Timeframe=0. 
extern bool      TimeFrame.Auto=True;      // Automatically select higher TF. M15 and M30 -> H1. Off=0, 1st HTF=1, 2nd HTF=2
extern string    ASCTrend.Settings="";
extern int       ASCTrend.Risk=6;          // Risk level. WPR_Period=3+Risk*2 or WPR_Period=ALT_PERIOD for a large move 
extern int       ASCTrend.BarCount=0;      // 0 for full chart buffer

// indicator buffers
double gadUp[];
double gadDn[];
double gadLine[];

// Globals
int giRepaintBars;
bool gbInit;


//-----------------------------------------------------------------------------
// function: init()
// Description: Custom indicator initialization function.
//-----------------------------------------------------------------------------
int init() {
  IndicatorBuffers(3); 
  SetIndexStyle(0,DRAW_HISTOGRAM);
  SetIndexBuffer(0,gadUp);
  SetIndexLabel(0,NULL);
  SetIndexStyle(1,DRAW_HISTOGRAM);
  SetIndexBuffer(1,gadDn);
  SetIndexLabel(1,NULL);
  SetIndexStyle(2,DRAW_LINE);
  SetIndexBuffer(2,gadLine);
  SetIndexLabel(2,NULL);
  
  // Set Timeframe
  switch(TimeFrame.Auto) {
    case 1: 
      TimeFrame.Period=NextHigherTF(TimeFrame.Period); 
      giRepaintBars=TimeFrame.Period/Period()+2;
    break;
    case 2: 
      TimeFrame.Period=NextHigherTF(NextHigherTF(TimeFrame.Period));
      giRepaintBars=TimeFrame.Period/Period()+2;
    break;
    default: 
      if (TimeFrame.Period<1 || TimeFrame.Period==Period()) {
        TimeFrame.Period=Period();
        giRepaintBars=0;
      }
      else {
        giRepaintBars=TimeFrame.Period/Period()+2;
      }
    break;
  }
  
  IndicatorShortName("ASCTrend1("+ASCTrend.Risk+")-"+TF2Str(TimeFrame.Period));
  
  // Check that required indicators are installed
  if (!IndicatorExists(IND_ASCTREND+".ex4"))
    Alert(Symbol()+", "+TF2Str(Period())+", "+INDICATOR_NAME+": Error! "+TerminalPath()+"\\experts\\indicators\\"+IND_ASCTREND+".ex4 cannot be found.");
  
  gbInit=True;
  return(0);
}


//-----------------------------------------------------------------------------
// function: deinit()
// Description: Custom indicator deinitialization function.
//-----------------------------------------------------------------------------
int deinit() {
   return (0);
}


//-----------------------------------------------------------------------------
// function: start()
// Description: Custom indicator iteration function.
//-----------------------------------------------------------------------------
int start() {
  int i, j, iNewBars, iCountedBars;
  static int iDivider=-1;
  static int iHTFBar=-1;
  double dSig0, dSig1;
  int iPeriodSec=TimeFrame.Period*60;  
  static datetime tNextBar;
  
  if (gbInit) {
    tNextBar=Time[Bars-1]/iPeriodSec;
    tNextBar=tNextBar*iPeriodSec+iPeriodSec;
    gbInit=False;
  }
  
  // Get unprocessed bars
  iCountedBars=IndicatorCounted();
  if(iCountedBars < 0) return (-1); 
  if(iCountedBars>0) iCountedBars--;
  
  // Set bars to redraw
  if (NewBars(TimeFrame.Period)>1)
    iNewBars=Bars-1;
  else
    iNewBars=Bars-iCountedBars;
  if (iNewBars<giRepaintBars)
    iNewBars=giRepaintBars;
  
  for(i=iNewBars; i>=0; i--) {
    // Shift index for higher time-frame
    if (TimeFrame.Period>Period() )
      j=iBarShift(Symbol(), TimeFrame.Period, Time[i], True);
    else
      j=i;
    
    // Calc indicator data
    if (iHTFBar!=j && j>=0) {
      iHTFBar=j;
      dSig0=iCustom(Symbol(),TimeFrame.Period,IND_ASCTREND,ASCTrend.Risk,ASCTrend.BarCount,2,j);
      if (gadLine[i]==EMPTY_VALUE) 
        if (TimeFrame.Period>Period())
          iDivider *=-1;
    }
    else if (j<0) {
      dSig0=0;
    }
    
    if (gadLine[i]==EMPTY_VALUE)
      if (TimeFrame.Period>Period())
        gadLine[i]=iDivider*DIVIDER_LINE;
    
    // Draw tape    
    gadUp[i]=EMPTY_VALUE;
    gadDn[i]=EMPTY_VALUE;
    if (dSig0==1)
      gadUp[i]=1;
    else if (dSig0==-1)
      gadDn[i]=1;
  }
  
  return(0);
}
//+------------------------------------------------------------------+


//-----------------------------------------------------------------------------
// function: NewBars()
// Description: Return nr of new bars on a TF
//-----------------------------------------------------------------------------
int NewBars(int iPeriod) {
  static int iPrevSize=0;
  int iNewSize;
  int iNewBars;
  datetime tTimeArray[];
  
  ArrayCopySeries(tTimeArray,MODE_TIME,Symbol(),iPeriod);
  iNewSize=ArraySize(tTimeArray);
  iNewBars=iNewSize-iPrevSize;
  iPrevSize=iNewSize;
  return(iNewBars);
}


//-----------------------------------------------------------------------------
// function: TF2Str()
// Description: Convert time-frame to a string
//-----------------------------------------------------------------------------
string TF2Str(int iPeriod) {
  switch(iPeriod) {
    case PERIOD_M1: return("M1");
    case PERIOD_M5: return("M5");
    case PERIOD_M15: return("M15");
    case PERIOD_M30: return("M30");
    case PERIOD_H1: return("H1");
    case PERIOD_H4: return("H4");
    case PERIOD_D1: return("D1");
    case PERIOD_W1: return("W1");
    case PERIOD_MN1: return("MN1");
    default: return("M"+iPeriod);
  }
  return(0);
}


//-----------------------------------------------------------------------------
// function: NextHigherTF()
// Description: Select the next higher time-frame. 
//              Note: M15 and M30 both select H1 as next higher TF. 
//-----------------------------------------------------------------------------
int NextHigherTF(int iPeriod) {
  if (iPeriod==0) iPeriod=Period();
  switch(iPeriod) {
    case PERIOD_M1: return(PERIOD_M5);
    case PERIOD_M5: return(PERIOD_M15);
    case PERIOD_M15: return(PERIOD_H1);
    case PERIOD_M30: return(PERIOD_H1);
    case PERIOD_H1: return(PERIOD_H4);
    case PERIOD_H4: return(PERIOD_D1);
    case PERIOD_D1: return(PERIOD_W1);
    case PERIOD_W1: return(PERIOD_MN1);
    case PERIOD_MN1: return(PERIOD_MN1);
    default: return(Period());
  }
  return(Period());
}


//-----------------------------------------------------------------------------
// function: IndicatorExists()
// Description: Check if an indicator exists
//-----------------------------------------------------------------------------
bool IndicatorExists(string sIndicatorName) {
  int hFile;
  string sFile;
    
  // Exit if dlls are disabled
  if (!IsDllsAllowed())
    return(True);
  
  // Try to open indicator 
  sFile=TerminalPath()+"\\experts\\indicators\\"+sIndicatorName;
  hFile=CreateFileA(sFile,0,FILE_SHARE_READ,0,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);  
  if (hFile==INVALID_HANDLE_VALUE) {
    return(False);    
  }
  else {
    CloseHandle(hFile);
    return(True);
  }
  return(False);
}